#Computing tracker program
#Example solution
#Programmed by Mr A Simpson
#Date: 02/11/2022
# ---------------------------------------------

# 3 Read pupil details from file
def readFromFile(classData):
    counter = 0

    with open("PupilDetails.csv") as readfile:
        line = readfile.readline().rstrip("\n")
        while line:
            items = line.split(",")
            classData[counter].forename = items[0]
            classData[counter].surname = items[1]
            classData[counter].gender = items[2]
            classData[counter].sddMark = int(items[3]) #Use int() to convert text into number - will be used for calculations later so must be numeric
            classData[counter].sysMark = int(items[4])
            classData[counter].dddMark = int(items[5])
            classData[counter].wddMark = int(items[6])

            line = readfile.readline().rstrip("\n")

            counter += 1


# -------------------------------------------
# 4. calculate average and determine grades
def calculateAvg(classData):

    for counter in range(0, len(classData)):

        #Calculate Average grade and add to record structure classData.
        classData[counter].average = (
            classData[counter].sddMark
            + classData[counter].sysMark
            + classData[counter].dddMark
            + classData[counter].wddMark
        ) / 4

        #Nested ifs to determine pupil grade. Grade added to record structure.
        if classData[counter].average >= 75:
            classData[counter].grade = "A"
        elif classData[counter].average >= 60:
            classData[counter].grade = "B"
        elif classData[counter].average >= 50:
            classData[counter].grade = "C"
        else:
            classData[counter].grade = "No Award"


# -----------------------------------------------
# 5 find top performing pupil
def findMaxPupil(classData,topPupil):
    #initialise local variables
    maximum = 0
    maxPos = 0

    #set first position of list to maximum
    maximum = classData[0].average

    #loop through each position from second item
    for counter in range(1, len(classData)):
        if classData[counter].average > maximum:
            maximum = classData[counter].average
            maxPos = counter
    topPupil = classData[maxPos].forename + " " + classData[maxPos].surname

    return topPupil


# -----------------------------------------------
# 6 count number of A passes
def countOccurences(classData, Apasses):

    for counter in range(0, len(classData)):
        if classData[counter].grade == "A":
            Apasses += 1
    return Apasses


# ----------------------------------------------
# 7 count number of No Awards for Male/Female
def countNoAwards(classData, MaleNA, FemaleNA):

    for counter in range(0, len(classData)):
        if classData[counter].grade == "No Award" and classData[counter].gender == "M":
            MaleNA += 1
        if classData[counter].grade == "No Award" and classData[counter].gender == "F":
            FemaleNA += 1
    return MaleNA, FemaleNA


# ---------------------------------------------
# 8 Display results to Screen
def DisplayResults(classData, MaleNA, FemaleNA, Apasses, topPupil):

    for counter in range(0, len(classData)):
        print(
            classData[counter].forename[0:1],
            classData[counter].surname,
            "achieved an average of",
            classData[counter].average,
            "for the 4 assessments - Grade",
            classData[counter].grade,
            "awarded",
        )
    print("**********************************************")
    print("The top performing pupil is", topPupil)
    print("The number of A passes is", Apasses)
    print("The number of male no awards is", MaleNA)
    print("The number of female no awards is", FemaleNA)


# ----------------------------------------------
# 9. Write to File
def writeToFile(classData, MaleNA, FemaleNA, Apasses, topPupil):
    with open("output.txt", "w") as writefile:

        for counter in range(0, len(classData)):
            writefile.write(
                classData[counter].forename[0:1]+ " "+ classData[counter].surname
                + " achieved an average of "+ str(classData[counter].average)
                + " for the 4 assessments - Grade "+ str(classData[counter].grade)+ " awarded.\n"
            )

        writefile.write("**********************************************")
        writefile.write("\nThe top performing pupil is "+ topPupil)
        writefile.write("\nThe number of A passes is "+ str(Apasses))
        writefile.write("\nThe number of male no awards is "+ str(MaleNA))
        writefile.write("\nThe number of female no awards is "+ str(FemaleNA))


# -----------------------------------------------
# Main Program

# 1-2 Declare and initialise variables

#Create Record Structure
from dataclasses import dataclass
@dataclass
class pupil:
    forename: str = ""
    surname: str = ""
    gender: str = ""
    sddMark: int = 0
    wddMark: int = 0
    dddMark: int = 0
    sysMark: int = 0
    average: float = 0.0
    grade: str = ""

#Create Array of Records
classData = [pupil() for x in range(10)]

Apasses = 0
topPupil = ""
MaleNA = 0
FemaleNA = 0

#------------------------------------------------
# 3 Call procedure to read the data from the text file
readFromFile(classData)

# 4 Call procedure to calculate average
calculateAvg(classData)

# 5 Call function to find topPupil marks
topPupil = findMaxPupil(classData,topPupil)

# 6 Call function to count A passes
Apasses = countOccurences(classData, Apasses)

# 7 Call procedure to count Male and Female No Awards
MaleNA, FemaleNA = countNoAwards(classData, MaleNA, FemaleNA)

# 8 Call procedure to display output
DisplayResults(classData, MaleNA, FemaleNA, Apasses, topPupil)

# 9 Call procedure to write the data to text file
writeToFile(classData, MaleNA, FemaleNA, Apasses, topPupil)
